//$**************************************************************
//$            Copyright (C) 1999 by Identix Inc.
//$
//$  Name:        $Workfile: memtiff.h $
//$
//$  Author:      $Author: Cparkinson $
//$  
//$  Description: 
//$
//$     Header file describing the memtiff DLL.  This DLL is
//$     used primarily in test programs as a very simplistic
//$     means of reading and writing TIFF files.
//$
//   $Header: /IdxTiff/INC/memtiff.h 1     9/10/03 9:46a Cparkinson $
// 
//   History Log:
//  
//   $History: memtiff.h $
// 
// *****************  Version 1  *****************
// User: Cparkinson   Date: 9/10/03    Time: 9:46a
// Created in $/IdxTiff/INC
// 
// *****************  Version 3  *****************
// User: Lfix         Date: 9/08/03    Time: 5:18p
// Updated in $/SlapNMatch/Test/Tiff
// Corrected bad comment delimiters.
// 
// *****************  Version 2  *****************
// User: Cparkinson   Date: 9/08/03    Time: 10:08a
// Updated in $/SlapNMatch/Test/Tiff
// New V1.0A of Jersy SlapNMatch
// * 
// * *****************  Version 1  *****************
// * User: Cparkinson   Date: 8/29/03    Time: 12:34p
// * Created in $/SlapNMatch/Test/Tiff
// 
// *****************  Version 5  *****************
// User: Lfix         Date: 2/16/03    Time: 3:26p
// Updated in $/include
// Cleaned up type problems.
// 
// *****************  Version 4  *****************
// User: Le           Date: 2/05/03    Time: 4:52p
// Updated in $/include
// Changes for Int-Localized version
// 
// *****************  Version 3  *****************
// User: Lfix         Date: 1/19/03    Time: 6:24p
// Updated in $/include
// Added include of tchar.h
// 
// *****************  Version 2  *****************
// User: Le           Date: 1/14/03    Time: 5:48p
// Updated in $/include
// changes for Int-Localize version.
// 
// *****************  Version 1  *****************
// User: Admin        Date: 12/30/02   Time: 4:35p
// Created in $/include
// Initially created for XP system
// 
// *****************  Version 2  *****************
// User: Dluc         Date: 7/31/00    Time: 6:41p
// Updated in $/include
// Modify IFNDEF statement
// 
// *****************  Version 1  *****************
// User: Gibbons      Date: 1/26/00    Time: 6:12p
// Created in $/include
// Initial check in
// 
//   $NoKeywords: $
//$**************************************************************

//SON modified
#ifndef MEMTIFF_H
#define MEMTIFF_H

#ifdef WIN32
	#ifdef IDX_TIFF_EXPORTS
		#define IDX_TIFF __declspec(dllexport)
	#else
		#define IDX_TIFF __declspec(dllimport)
	#endif
#else
	#define IDX_TIFF 
#endif

typedef struct {
    short   bitsPerSample;
    long    imageWidth;
    long    imageLength;
    short   xResolution;
    short   yResolution;
    short   photometric;
} TiffInfo;

typedef unsigned char   Byte;

#if defined(__cplusplus)
extern "C" {
#endif

IDX_TIFF int readTiffFile (char *filename, Byte *imgData);
IDX_TIFF int writeTiffFile (char *filename, Byte *imgData, TiffInfo *tiffInfo);
IDX_TIFF long getTiffFileInfo (char *filename, TiffInfo *tiffInfo);

#if defined(__cplusplus)
}
#endif

#define     MEMTIFF_OK               0
#define     MEMTIFF_ERR_OPEN        -1
#define     MEMTIFF_ERR_READ        -2
#define     MEMTIFF_ERR_WRITE       -3

#endif  //SON modified

